/*
 * Decompiled with CFR 0.152.
 */
package alabaster.crabbersdelight.common.block.entity;

import alabaster.crabbersdelight.CrabbersDelight;
import alabaster.crabbersdelight.common.Config;
import alabaster.crabbersdelight.common.block.container.CrabTrapMenu;
import alabaster.crabbersdelight.common.block.entity.inventory.CrabTrapItemHandler;
import alabaster.crabbersdelight.common.registry.ModBlockEntity;
import alabaster.crabbersdelight.common.tags.CDModTags;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.RangedWrapper;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class CrabTrapBlockEntity
extends BlockEntity
implements MenuProvider,
Nameable {
    public static final Component CRAB_TRAP_NAME = Component.m_237115_((String)"block.crabbersdelight.crab_trap");
    private final CrabTrapItemHandler inventory = new CrabTrapItemHandler(){

        protected void onContentsChanged(int slot) {
            CrabTrapBlockEntity.this.m_6596_();
        }
    };
    private final LazyOptional<IItemHandler> input = LazyOptional.of(() -> new RangedWrapper((IItemHandlerModifiable)this.inventory, 0, 1));
    private final LazyOptional<IItemHandler> output = LazyOptional.of(() -> new RangedWrapper((IItemHandlerModifiable)this.inventory, 1, 19));
    private int tickCounter = 0;

    public CrabTrapBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntity.CRAB_TRAP.get(), pos, state);
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("handler", (Tag)this.inventory.serializeNBT());
        tag.m_128405_("tickCounter", this.tickCounter);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.inventory.deserializeNBT(tag.m_128469_("handler"));
        this.tickCounter = tag.m_128451_("tickCounter");
    }

    private CompoundTag saveItems(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128365_("handler", (Tag)this.inventory.serializeNBT());
        return compound;
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.saveItems(new CompoundTag());
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet) {
        this.m_142466_(packet.m_131708_());
    }

    public static Pair<Integer, Integer> getMinMax() {
        return Pair.of((Object)((Integer)Config.MIN_TICKS.get()), (Object)((Integer)Config.MAX_TICKS.get()));
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, CrabTrapBlockEntity blockEntity) {
        RandomSource random = level.m_213780_();
        if ((Integer)CrabTrapBlockEntity.getMinMax().getSecond() > (Integer)CrabTrapBlockEntity.getMinMax().getFirst()) {
            if (blockEntity.tickCounter >= random.m_216332_(((Integer)CrabTrapBlockEntity.getMinMax().getFirst()).intValue(), ((Integer)CrabTrapBlockEntity.getMinMax().getSecond()).intValue())) {
                blockEntity.tickCounter = 0;
                if (CrabTrapBlockEntity.isValidFishingLocation(level, pos)) {
                    LootTable loottable;
                    LootContext.Builder lootcontext$builder = new LootContext.Builder((ServerLevel)level).m_78972_(LootContextParams.f_81460_, (Object)new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_())).m_78972_(LootContextParams.f_81463_, (Object)ItemStack.f_41583_).m_78972_(LootContextParams.f_81462_, (Object)blockEntity).m_230911_(random);
                    ItemStack itemInBaitSlot = blockEntity.inventory.getStackInSlot(0);
                    level.m_6263_(null, (double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 0.5f), (double)((float)pos.m_123343_() + 0.5f), SoundEvents.f_11938_, SoundSource.BLOCKS, 0.5f, 1.0f);
                    if (itemInBaitSlot.m_204117_(CDModTags.CRAB_TRAP_BAIT) && !itemInBaitSlot.m_150930_(Items.f_41852_)) {
                        ResourceLocation registryName = ForgeRegistries.ITEMS.getKey((Object)itemInBaitSlot.m_41720_());
                        ResourceLocation lootTableLocation = CrabbersDelight.modPrefix("gameplay/crab_trap_loot/" + Objects.requireNonNull(registryName).m_135827_() + "/" + registryName.m_135815_());
                        loottable = level.m_7654_().m_129898_().m_79217_(lootTableLocation);
                    } else if (CrabTrapBlockEntity.isTreasureFishingLocation(level, pos)) {
                        lootTableLocation = CrabbersDelight.modPrefix("gameplay/crab_trap_loot/minecraft/treasure");
                        loottable = level.m_7654_().m_129898_().m_79217_(lootTableLocation);
                    } else {
                        lootTableLocation = CrabbersDelight.modPrefix("gameplay/crab_trap_loot/minecraft/junk");
                        loottable = level.m_7654_().m_129898_().m_79217_(lootTableLocation);
                    }
                    ObjectArrayList list = loottable.m_230922_(lootcontext$builder.m_78975_(LootContextParamSets.f_81414_));
                    blockEntity.inventory.addItemsAndShrinkBait((List<ItemStack>)list, itemInBaitSlot);
                }
            } else {
                ++blockEntity.tickCounter;
            }
        } else {
            CrabbersDelight.LOGGER.error("Error: Miniumum value is higher than maximum value!");
        }
    }

    private static boolean isValidFishingLocation(Level level, BlockPos pos) {
        for (Direction direction : Direction.values()) {
            if (!level.m_8055_(pos).m_60819_().m_205070_(FluidTags.f_13131_) || !level.m_6425_(pos.m_121945_(direction)).m_205070_(FluidTags.f_13131_)) continue;
            return true;
        }
        return false;
    }

    private static boolean isTreasureFishingLocation(Level level, BlockPos pos) {
        for (BlockPos nearbyPos : BlockPos.m_121940_((BlockPos)pos.m_7918_(-2, 0, -2), (BlockPos)pos.m_7918_(2, 2, 2))) {
            if (level.m_6425_(nearbyPos).m_205070_(FluidTags.f_13131_)) continue;
            return false;
        }
        return true;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap.equals((Object)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY)) {
            if (side == null || side.equals((Object)Direction.UP)) {
                return this.input.cast();
            }
            return this.output.cast();
        }
        return super.getCapability(cap, side);
    }

    public CrabTrapItemHandler getInventory() {
        return this.inventory;
    }

    public Component m_7755_() {
        return CRAB_TRAP_NAME;
    }

    public Component m_5446_() {
        return CRAB_TRAP_NAME;
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory playerInv, Player player) {
        return new CrabTrapMenu(id, playerInv, this.inventory);
    }
}

